/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.review.client.api;

/**
 * <code>ReviewException</code> is a generic exception for all failures in the Review API.
 */
public class ReviewException extends Exception {

    /** A serialVersionUID for this class. */
    private static final long serialVersionUID = 1L;

    /**
     * Creates a ReviewException.
     * @param message A message that is to be goes with the exception
     */
    public ReviewException(final String message) {
        super(message);
    }

    /**
     * Creates a ReviewException.
     * @param message A message that goes with the exception
     * @param cause The underlying cause for the exception
     */
    public ReviewException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a ReviewException.
     * @param cause The underlying cause for the exception
     */
    public ReviewException(final Throwable cause) {
        super(cause);
    }

}
