/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.review.client.api;

import java.util.Map;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.tally.client.api.VotingSocialComponent;

/**
 * Social Component for any Review resource.
 */
public interface ReviewSocialComponent<C extends CommentCollectionConfiguration> extends Comment<C> {
    /**
     * @return a map of all rating titles to its user responses.
     */
    Map<String, Long> getRatingResponses() throws ReviewException;

    /**
     * @return return voting for the review.
     */
    VotingSocialComponent getVoting();

    /**
     * Return true if the review has composite ratings.
     * @return true if the review has composite ratings.
     */
    boolean isCompositeRating();

}
