/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.review.client.api;

import javax.jcr.RepositoryException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.review.client.impl.ReviewSocialComponentImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialCollectionComponentFactory;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

/**
 * Social Comment Component Factory which allows the framework to create an {@link SocialComponent} for a Review
 * resource.
 */
@Component
@Service
public class ReviewSocialComponentFactory extends AbstractSocialComponentFactory implements
    SocialCollectionComponentFactory {

    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        try {
            return new ReviewSocialComponentImpl(resource, this.getClientUtilities(resource.getResourceResolver()),
                listProviderManager);
        } catch (final RepositoryException e) {
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        try {
            return new ReviewSocialComponentImpl(resource, this.getClientUtilities(request),
                getQueryRequestInfo(request), listProviderManager);
        } catch (final RepositoryException e) {
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryInfo) {
        try {
            return new ReviewSocialComponentImpl(resource, clientUtils, queryInfo, listProviderManager);
        } catch (final RepositoryException e) {
            return null;
        }
    }

    @Override
    public String getSupportedResourceType() {
        return ReviewConstants.REVIEW_RESOURCE_TYPE;
    }

}
