/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.review.client.endpoints;

import java.util.List;

import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationExtension;

/**
 * Hook operation to enable clients register callback during an execution of an operation.
 */
public interface ReviewOperationExtension extends OperationExtension<Comment> {
    /**
     * Enumeration of available Review operations.
     */
    public enum ReviewOperation implements Operation {
        /** Create Operation. */
        CREATE,
        /** Update operation. */
        UPDATE,
        /** Delete operation. */
        DELETE,
        /** Edit Translation operation **/
        EDIT_TRANSLATION, UPLOAD_IMAGE;
    };

    /**
     * Get the list of operations that this operation extension is interested in.
     * @return a list of {@link ReviewOperation}
     */
    @Override
    List<ReviewOperation> getOperationsToHookInto();
}
