/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

/**
 * Pagination settings use by the SocialCollectionComponent to determine the number of items on a page and embed
 * levels.
 */
public class CollectionPagination {

    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_EMBED_LEVEL = 0;
    public static final CollectionPagination DEFAULT_PAGINATION = new CollectionPagination(0);
    public static final CollectionPagination EMBEDDED_LEVEL_PAGINATION = new CollectionPagination(0,
        DEFAULT_PAGE_SIZE, -1);

    private final int offset;
    private final int size;
    private final int embedLevel;
    private final String selectedIndex;
    private final int pageSizeConfig;

    /**
     * @param offset offset from the beginning of the list.
     * @param size number of elements to include.
     * @param embedLevel the level from which items should be embedded as URLs. 0 is the first level.
     */
    public CollectionPagination(final int offset, final int size, final int embedLevel, final String selectedIndex) {
        this.offset = offset;
        this.size = size;
        this.embedLevel = embedLevel;
        this.selectedIndex = selectedIndex;
        this.pageSizeConfig = DEFAULT_PAGE_SIZE;
    }

    /**
     * @param offset offset from the beginning of the list.
     * @param size number of elements to include.
     * @param embedLevel the level from which items should be embedded as URLs. 0 is the first level.
     * @param selectedIndex the index that was requested to be used
     * @param pageSizeConfig the configured size of each page for the component
     */
    public CollectionPagination(final int offset, final int size, final int embedLevel, final String selectedIndex,
        final int pageSizeConfig) {
        this.offset = offset;
        this.size = size;
        this.embedLevel = embedLevel;
        this.selectedIndex = selectedIndex;
        this.pageSizeConfig = pageSizeConfig;
    }

    /**
     * @param offset offset from the beginning of the list.
     * @param size number of elements to include.
     * @param embedLevel the level from which items should be embedded as URLs. 0 is the first level.
     */
    public CollectionPagination(final int offset, final int size, final int embedLevel) {
        this(offset, size, embedLevel, null);
    }

    /**
     * This uses the default embed level.
     * @param offset offset from the beginning of the list.
     * @param size number of elements to include.
     */
    public CollectionPagination(final int offset, final int size) {
        this(offset, size, DEFAULT_EMBED_LEVEL, null);
    }

    /**
     * This uses the default embed level and page size.
     * @param offset offset from the beginning of the list.
     */
    public CollectionPagination(final int offset) {
        this(offset, DEFAULT_PAGE_SIZE, DEFAULT_EMBED_LEVEL, null);
    }

    public CollectionPagination(final CollectionPagination copyFrom) {
        this.offset = copyFrom.getOffset();
        this.size = copyFrom.getSize();
        this.selectedIndex = copyFrom.getSelectedIndex();
        this.embedLevel = copyFrom.getEmbedLevel();
        this.pageSizeConfig = copyFrom.getPageSizeConfig();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public String getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getEmbedLevel() {
        return this.embedLevel;
    }

    public int getPageSizeConfig() {
        return this.pageSizeConfig;
    }
}
