/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

public class HttpStatusTextProvider {

    public static Map<Integer, String> statusMap = null;

    private static void init() {
        if (statusMap != null) {
            return;
        }
        Map<Integer, String> map = new HashMap<Integer, String>();
        Field[] field = HttpServletResponse.class.getDeclaredFields();
        for (Field f : field) {
            if (f.isSynthetic()) {
                continue;
            }
            int mods = f.getModifiers();
            if (!Modifier.isPublic(mods)) {
                continue;
            }
            if (!Modifier.isFinal(mods)) {
                continue;
            }
            if (!Modifier.isStatic(mods)) {
                continue;
            }
            if (f.getType() == int.class && f.getName().startsWith("SC_")) {
                String name = f.getName().replace("SC_", "").replace("_", " ");
                try {
                    map.put(f.getInt(null), name);
                } catch (IllegalArgumentException e) {
                    // not possible.
                } catch (IllegalAccessException e) {
                    // not possible.
                }
            }
        }
        statusMap = map;
    }

    public static String getStatusText(int statusCode) {
        init();
        String result = statusMap.get(statusCode);
        if (result != null) {
            return result;
        }
        return "UNKOWN";
    }
}
