/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

/**
 * This exception is thrown when there is an error when an operation is being performed. operation.
 */
public class OperationException extends Exception {

    private static final long serialVersionUID = 1L;

    private final int errorCode;

    /**
     * Constructs a new CommentOperationException with the specified message and cause.
     * @param message The detailed message.
     * @param errorCode the HTTP error code that can be associated with this exception.
     */
    public OperationException(final String message, final int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new CommentOperationException with the specified message and cause.
     * @param message The detailed message
     * @param cause The cause
     * @param errorCode the HTTP error code that can be associated with this exception.
     */
    public OperationException(final String message, final Throwable cause, final int errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    /**
     * Constructs a new CommentOperationException with the specified message and cause.
     * @param cause The cause
     * @param errorCode the HTTP error code that can be associated with this exception.
     */
    public OperationException(final Throwable cause, final int errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    /**
     * Get the HttpResponse error code.
     * @return the HTTP error code associated with this exception.
     */
    public int getErrorCode() {
        return this.errorCode;
    }
}
