/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import java.util.List;
import java.util.Map;

import javax.jcr.Session;

import org.apache.sling.api.resource.Resource;

/**
 * An extension that might be called by an operation service before and after the specified operation is performed.
 * @param <T>
 */
public interface OperationExtension<T> {

    // Default extension order.
    int DEFAULT_ORDER = Integer.MAX_VALUE;
    // OSGi property name of the Extension order
    String PROP_EXTENSION_ORDER = "extension.order";

    /**
     * @return the extension calling order
     */
    int getOrder();

    /**
     * @return the name of the operation.
     */
    String getName();

    /**
     * @return list of operations for which this extension should be applied to.
     */
    List<? extends Operation> getOperationsToHookInto();

    /**
     * Callback method before the operation is performed; the extension can abort the operation by throw an
     * {@link OperationException} with appropriate HTTP error code.
     * @param the requested {@link Operation}.
     * @param session the session used by the operation.
     * @param resource the resource on which the operation is being performed. The {@link Session} of this resource
     *            belongs to the original request.
     * @param requestParameters the parameters that have been passed as part of the request to perform the operation.
     * @throws OperationException thrown if any one of the operations extensions throws an exception. This aborts the
     *             operations.
     */
    void beforeAction(final Operation operation, final Session session, final Resource resource,
        final Map<String, Object> requestParameters) throws OperationException;

    /**
     * Callback method after the operation is performed.
     * @param the requested {@link Operation}.
     * @param session the session that is being used to perform the operation.
     * @param component the resource on which the operation is being performed. The {@link Session} of this resource
     *            belongs to the original request.
     * @param requestParameters the parameters that have been passed as part of the request to perform the operation.
     * @throws OperationException thrown if any one of the operations extensions throws an exception.
     */
    void afterAction(final Operation operation, final Session session, final T component,
        final Map<String, Object> requestParameters) throws OperationException;
}
