/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import java.util.Map;

import javax.jcr.Session;

import org.apache.sling.api.resource.Resource;

/**
 * A service that support OperationExtentions.
 * @param <T> the specific type of {@link OperationExtension} supported by this service.
 * @param <U> the specific set of operations supported by this service.
 * @param <S> the object representing the resource/component that the service was performed on.
 */
@SuppressWarnings("rawtypes")
public interface OperationService<T extends OperationExtension, U extends Operation, S> {
    /**
     * add an {@link OperationExtension} to the list of operation extensions used by this service.
     * @param extension an OperationExtension that will be called before and after operations are performed.
     */
    void addOperationExtension(T extension);

    /**
     * remove an {@link OperationExtension} from the list of operation extensions used by this service.
     * @param extension the OperationExtension that should be removed from the list of operation extenstions used by
     *            this service.
     */
    void removeOperationExtension(T extension);

    /**
     * Get the {@link InheritedOperationManager} which allows parent extension to be executed as part of the
     * operation.
     * @return extensionManager
     */
    InheritedOperationExtensionManager getInheritedOperationExtensionManager();

    /**
     * perform all before actions supplied by the added operations extensions for a given operation.
     * @param operation the operation for which before actions needs to be performed.
     * @param session the session that is being used to perform the operation.
     * @param resource the resource on which the operation is being performed.
     * @param requestParameters the parameters that have been passed as part of the request to perform the operation.
     * @throws OperationException thrown if any one of the operations extensions throws an exception. This aborts the
     *             operations.
     */
    void performBeforeActions(U operation, final Session session, final Resource resource,
        final Map<String, Object> requestParameters) throws OperationException;

    /**
     * perform all after actions supplied by the added operations extensions for a given operation.
     * @param operation the operation for which after actions needs to be performed.
     * @param session the session that is being used to perform the operation.
     * @param component the resource on which the operation is being performed.
     * @param requestParameters the parameters that have been passed as part of the request to perform the operation.
     * @throws OperationException thrown if any one of the operations extensions throws an exception.
     */
    void performAfterActions(U operation, final Session session, final S component,
        final Map<String, Object> requestParameters) throws OperationException;

}
