/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;

/**
 * The QueryRequestInfo maintains information such as pagination, query predicates of a client request.
 * @author thuynh
 */
public interface QueryRequestInfo {

    public interface QueryRequestInfoFactory {
        QueryRequestInfo create();

        QueryRequestInfo create(QueryRequestInfo copyFrom);
    }

    QueryRequestInfoFactory DEFAULT_QUERY_INFO_FACTORY = new QueryRequestInfoFactory() {
        @Override
        public QueryRequestInfo create() {
            return new BaseQueryRequestInfo(false, Collections.<String, String[]>emptyMap(),
                CollectionPagination.DEFAULT_PAGINATION, false);
        }

        @Override
        public QueryRequestInfo create(final QueryRequestInfo copyFrom) {
            if (copyFrom != null) {
                final QueryRequestInfo newQueryInfo =
                    new BaseQueryRequestInfo(copyFrom.isQuery(), new HashMap<String, String[]>(
                        copyFrom.getPredicates()), new CollectionPagination(copyFrom.getPagination()),
                        copyFrom.isTranslationRequest());
                if (copyFrom.getSortBy() != null) {
                    newQueryInfo.setSortBy(new ArrayList<String>(copyFrom.getSortBy()));
                }
                newQueryInfo.setSortOrder(copyFrom.getSortOrder());
                return newQueryInfo;
            } else {
                return create();
            }
        }
    };

    /**
     * Is the request a query request
     */
    boolean isQuery();

    /**
     * Is the request a translate request
     */
    boolean isTranslationRequest();

    /**
     * Set the translation request
     * @param translation request value
     */
    void setTranslationRequest(boolean isTranslationRequest);

    /**
     * Get the query predicates.
     * @return null if the request is not a query request, otherwise, the method returns a map of the query predicates
     */
    Map<String, String[]> getPredicates();

    /**
     * Get the request paging specification
     */
    CollectionPagination getPagination();

    /**
     * Set the pagination
     * @param pagination the pagination setting.
     */
    void setPagination(final CollectionPagination pagination);

    /**
     * @param a list of indexes to use to sort the list by
     */
    void setSortBy(final List<String> sortBy);

    /**
     * @return the list of index names requested to sort the list by
     */
    List<String> getSortBy();

    /**
     * @param order for the list
     */
    void setSortOrder(final CollectionSortedOrder order);

    /**
     * @return the requested order to sort the list by
     */
    CollectionSortedOrder getSortOrder();
}
