/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.jackrabbit.api.security.user.Authorizable;

import javax.annotation.CheckForNull;

/**
 * @author vibhatia
 */
public interface SocialAuthorizable extends SocialComponent {

    /**
     * User display name.
     * @return the user name
     */
    String getName();

    /**
     * @return the userId of the user.
     */
    String getAuthorizableId();

    /**
     * Get the path of the user.
     * @return The path of the user
     */
    @CheckForNull
    String getPath();

}
