/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.scf;

import java.util.List;

import com.adobe.cq.social.scf.core.CollectionSortedOrder;

/**
 * An object that represents a component that is primarily a collection of another component.
 */
public interface SocialCollectionComponent extends SocialComponent {
    /**
     * Get total size of the collection.
     * @return the size of the collection.
     */
    int getTotalSize();

    /**
     * Set the collection pagination to define how getItems() should be paginated.
     * @param pagination an object defining the how the list of items should be paginated.
     */
    void setPagination(final CollectionPagination pagination);

    /**
     * Set the collection sorted order.
     * @param sortedOrder the order definition of how the items should be sorted.
     */
    void setSortedOrder(final CollectionSortedOrder sortedOrder);

    /**
     * Returns a list of children of this collection. Use setPagination() to set pagination properties before calling
     * this method.
     * @return A {@link List} of children of this collection, or an empty list if no children are present. If the
     *         children is the first level child, then the child is embedded in the list, otherwise, the child url is
     *         included in the list.
     */
    List<Object> getItems();
}
