/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.scf;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public interface SocialCollectionComponentFactory extends SocialComponentFactory {
    /**
     * @param resource the resource for which a SocialComponent is requested for.
     * @param request The <@link ClientUtilities> instance that associates with the current HTTP request.
     * @param requestInfo the pagination applicable to the resoure children list.
     * @return an implementation of SocialComponent for the given resource.
     * @see AbstractSocialComponentFactory#getClientUtilities(SlingHttpServletRequest)
     */
    @Override
    SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo requestInfo);
}
