/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import java.util.Map;
import java.util.Properties;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.core.ResourceID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * An easy to use, client friendly object that represent Social components.
 */
public interface SocialComponent {
    public static final String DEFAULT_SELECTOR = "social";
    public static final String QUERY_SELECTOR = "social.query";
    public static final String INDEX_SELECTOR = "index";
    public static final String TRANSLATE_SELECTOR = "social.translate";

    /**
     * Request parameter and header name for referrer Url.
     */
    String PROP_REFERER = "referer";

    /**
     * @return the ResourceID of the resource.
     */
    ResourceID getId();

    /**
     * @return the resource type of the resource.
     */
    String getResourceType();

    /**
     * @return the url to the resource if possible.
     */
    String getUrl();

    /**
     * @return a list of resource properties.
     */
    Properties getProperties();

    /**
     * @param tidy true to return readable JSON string.
     * @return JSON representation of this object.
     * @throws JsonException if an error occurs during serialization.
     */
    String toJSONString(final boolean tidy) throws JsonException;

    /**
     * @return the resource represented by this SocialComponent.
     */
    Resource getResource();

    /**
     * @return this object represented as a map.
     */
    Map<String, Object> getAsMap();

    /**
     * Gets the immediate parent of this component.
     * @return the parent social component or {code}null{/code} if none exists
     */
    @JsonIgnore
    SocialComponent getParentComponent();

    /**
     * Gets the SocialComponent that created this piece of UGC. This generally links back to the component that is in
     * the real content tree.
     * @return the source social component
     */
    @JsonIgnore
    SocialComponent getSourceComponent();

    /**
     * Get a url that can be used to display this component, most of the time, this is the page url that contains the
     * component. This method method may return null value if there is no available friendly url .
     */
    @JsonInclude(Include.NON_NULL)
    String getFriendlyUrl();
}
