/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

/**
 * A factory that will create instances of {@link SocialComponent} given a {@link Resource}.
 */
public interface SocialComponentFactory {
    /**
     * @param resource the resource for which a SocialComponent is requested for.
     * @return an implementation of SocialComponent for the given resource.
     */
    SocialComponent getSocialComponent(Resource resource);

    /**
     * @param resource the resource for which a SocialComponent is requested for.
     * @param request the HTTP request for which this SocialComponent is being instantiated for.
     * @return an implementation of SocialComponent for the given resource.
     */
    SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request);

    /**
     * @param resource the resource for which a SocialComponent is requested for.
     * @param request The <@link ClientUtilities> instance that associates with the current HTTP request.
     * @param requestInfo the pagination applicable to the resoure children list.
     * @return an implementation of SocialComponent for the given resource.
     * @see AbstractSocialComponentFactory#getClientUtilities(SlingHttpServletRequest)
     */
    SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo requestInfo);

    /**
     * This determines the priority of this factory with respect to other factories that support the same resource
     * types as this factory. Use a higher number to override default factories.
     * @return an integer that reprenses the priority of this factory.
     */
    int getPriority();

    /**
     * @return the resource type string that determines which resources this factory can created SocialComponents for.
     */
    String getSupportedResourceType();
}
