/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import org.apache.sling.api.resource.Resource;

/**
 * A manager that determines which SocialComponentFactory manager should be used for a given Resource or resource
 * type. This manager considers the priorities and resource types supported by the SocialComponentFactories. It also
 * respects resource type inheritance, i.e, it will always return the most specific SocialComponentFactory, given a
 * resource or resource type as per the resource type hierarchy.
 */
public interface SocialComponentFactoryManager {

    /**
     * @param resource the resource for which a SocialComponentFactory is requested for.
     * @return a SocialComponentFactory that can handle the given resource.
     */
    SocialComponentFactory getSocialComponentFactory(Resource resource);

    /**
     * @param resourceType the resource type for which a SocialComponentFactory is requested for.
     * @return a SocialComponentFactory that can handle the given resource resource type.
     */
    SocialComponentFactory getSocialComponentFactory(String resourceType);

}
