/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import com.adobe.cq.social.commons.annotation.Endpoint;
import com.adobe.cq.social.commons.annotation.Parameters;

/**
 * This interface fetches the <code>com.adobe.cq.social.commons.annotation</code> from the Social endpoint at runtime
 * to provide the endpoint information to the end user.
 */
public interface SocialOperationInfo {
    /**
     * Get the {@link Endpoint} information.
     * @return the endpoint information
     */
    Endpoint getEndpoint();

    /**
     * Get the {@link Parameters} of the endpoint.
     * @return the endpoint parameter list.
     */
    Parameters getRequestParameters();
}
