/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

/**
 * Defines the result of an Operation.
 */
public class SocialOperationResult {
    private final SocialComponent resource;
    private final String httpStatusMessage;
    private final int httpStatusCode;
    private final String path;

    /**
     * @param resource the social component that was part of the operation. This resource is converted to json which
     *            is returned in the payload.
     * @param httpStatusMessage HTTP status message
     * @param httpStatusCode HTTP status code
     * @param path path to the resource that was touch by the operation.
     */
    public SocialOperationResult(final SocialComponent resource, final String httpStatusMessage,
        final int httpStatusCode, final String path) {
        super();
        this.resource = resource;
        this.httpStatusMessage = httpStatusMessage;
        this.httpStatusCode = httpStatusCode;
        this.path = path;
    }

    /**
     * @param resource the social component that was part of the operation. This resource is converted to json which
     *            is returned in the payload.
     * @param httpStatusCode HTTP status code
     * @param path path to the resource that was touch by the operation.
     */
    public SocialOperationResult(final SocialComponent socialComponent, final int responseStatus,
        final String resourcePath) {
        this(socialComponent, HttpStatusTextProvider.getStatusText(responseStatus), responseStatus, resourcePath);
    }

    /**
     * @return the SocialComponent that was part of the operation.
     */
    public SocialComponent getResource() {
        return this.resource;
    }

    /**
     * @return HTTP status message
     */
    public String getHttpStatusMessage() {
        return this.httpStatusMessage;
    }

    /**
     * @return HTTP status code
     */
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    /**
     * @return path to the resource that was touch by the operation.
     */
    public String getPath() {
        return this.path;
    }

}
