/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

public interface User extends SocialAuthorizable {

    public static final String RESOURCE_TYPE = "social/commons/components/author";

    /**
     * An interface that represents a badge that is awarded to community users.
     */
    public interface Badge {
        /**
         * @return name of the badge
         */
        String getTitle();

        /**
         * @return externalized url to the badge's image
         */
        String getImageUrl();

        /**
         * @return whether the badge is an assigned badge
         */
        boolean getIsAssigned();
    }

    static final String SOCIAL_AUTHORS_PREFIX = "/social/authors/";

    /**
     * Get URL to fetch the user avatar.
     * @return the url of the user avatar
     */
    String getAvatarUrl();

    /**
     * Get URL to fetch the user avatar (48px).
     * @return the url of the user avatar
     */
    String getLargeAvatarUrl();

    /**
     * Get externalized URL to the profile page
     * @return an externalized URL to the user's public profile
     */
    @JsonInclude(Include.NON_EMPTY)
    String getProfileUrl();

    /**
     * @return number of forum posts authored by the user
     */
    @Deprecated
    Long getNumberOfPosts();

    /**
     * @return a list of badges that the user has been awarded
     */
    List<Badge> getBadges();

    /**
     * @return true if the user is disabled, false otherwise
     */
    Boolean getDisabled();

    /**
     * @return user id
     */
    @JsonIgnore
    String getUserId();

    /**
     * @return if the user is disabled, return the string containing the reason, otherwise return null
     */
    String getDisabledReason();
}
