/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf.community;

import com.adobe.cq.social.scf.User;

public interface CommunityUser extends User {

    String RESOURCE_TYPE = "social/console/components/hbs/users/user";

    /**
     * Get the sites that this user belong to their user GROUP_ADMIN group
     */
    @Deprecated
    String[] getMemberOfGroupAdmin();

    /**
     * Get the sites that this user is a member of the MODERATOR group
     */
    @Deprecated
    String[] getMemberOfModeratorGroup();

    /**
     * Get the sites that this user is a member of the CONTENT_MANAGER group
     */
    @Deprecated
    String[] getMemberOfContentManagerGroup();

    /**
     * Get URL to fetch the user avatar (150px).
     * @return the url of the user avatar
     */
    String getSuperSizeAvatarUrl();

    /**
     * check if the user is admin
     */
    boolean isAdmin();

    /**
     * Get user wall url
     */
    String getWallUrl();

    /**
     * Get user profile path
     */
    String getProfilePath();

    /**
     * Get the description of the User
     */
    String getDescription();
}
