/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf.core;

import org.apache.sling.api.resource.Resource;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Default implementation of {@link ResourceID}.
 */
public class DefaultResourceID implements ResourceID {
    private final String id;

    /**
     * @param id the unique id to the resource
     */
    public DefaultResourceID(final String id) {
        this.id = id;
    }

    /**
     * The resource path is used as the unique ID. This is the case in JCR.
     * @param resource the resource which is identified by this ResourceID.
     */
    public DefaultResourceID(final Resource resource) {
        this.id = resource.getPath();
    }

    @Override
    @JsonValue
    public String getResourceIdentifier() {
        return this.id;
    }

    @Override
    public String toString() {
        return this.id;
    }

}
