/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scf.core.operations;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

import com.adobe.cq.social.scf.OperationExtension;

/**
 * Abstract base class for a Social Operation Extension Service
 */
@Component(metatype = false, componentAbstract = true)
public abstract class AbstractOperationExtensionService<T> implements OperationExtension<T> {

    /** Priority level of the component */
    @Property(name = PROP_EXTENSION_ORDER, intValue = DEFAULT_ORDER)
    protected int order;

    /**
     * Get the operation startup order
     */
    @Override
    public int getOrder() {
        return order;
    }

    /**
     * Activate this component.
     * @param context The component context
     */
    protected void activate(final ComponentContext context) {
        order = OsgiUtil.toInteger(context.getProperties().get(PROP_EXTENSION_ORDER), DEFAULT_ORDER);
    }
}
