/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.scf.core.resourcetree;

import java.util.Comparator;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * A comparator to compare two resource types in order to check which is one is a parent and which on is a child.
 * Incase the two resource types do not belong to the same resource type hierarchy chain, a {@link ClassCastException}
 * is thrown.
 * @author palanisw
 */
public class ResourceTypeIsAComparator implements Comparator<String> {

    private final ResourceResolver adminResolver;

    /**
     * @param adminResolver a {@link ResourceResolver} with administrative privileges used to compare the resource
     *            types of two resources.
     */
    public ResourceTypeIsAComparator(final ResourceResolver adminResolver) {
        this.adminResolver = adminResolver;
    }

    /*
     * (non-Javadoc)
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    @Override
    public int compare(final String arg0, final String arg1) {
        final Resource resource0 = this.adminResolver.resolve(arg0);
        final Resource resource1 = this.adminResolver.resolve(arg1);
        if (StringUtils.equals(resource0.getPath(), resource1.getPath())) {
            return 0;
        }
        if (this.adminResolver.isResourceType(resource0, arg1)) {
            return 1;
        }
        if (this.adminResolver.isResourceType(resource1, arg0)) {
            return -1;
        }
        throw new ClassCastException(arg0 + " and " + arg1 + " don't belong to a hierarchy chain.");
    }

}
