/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.scf.core.servlets;

import java.io.IOException;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.ugcbase.osgi.BundleServices;

/**
 * The <code>AbstractSessionServlet</code> provides the basic facilities for getting or creating session based on a
 * request. Implementations may vary on the properties persisted and request handling.
 * @deprecated We now recommend directly extending {@link org.apache.sling.api.servlets.SlingAllMethodsServlet} and
 *             using the Sling {@link org.apache.sling.api.resource.ResourceResolverFactory} and
 *             {@link org.apache.sling.api.SlingHttpServletRequest} APIs to acquire any necessary ResourceResolvers
 *             for interaction with the JCR repository and SocialResourceProviders.
 * @since CQ 5.6.0
 */
@Deprecated
@Component(metatype = false, componentAbstract = true)
public abstract class AbstractSessionServlet extends SlingAllMethodsServlet {
    /**
     * Serial ID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Sling repository for finding / creating nodes.
     */
    @Reference(cardinality = ReferenceCardinality.MANDATORY_UNARY, policy = ReferencePolicy.STATIC)
    protected SlingRepository repository;

    private static final String UGC_WRITER = "ugc-writer";

    /**
     * The logger for this class.
     */
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected abstract void doPost(final SlingHttpServletRequest request, final SlingHttpServletResponse response)
        throws ServletException, IOException;

    /**
     * Logout an administrative {@link Session}.
     * @param adminSession the administrative session to logout.
     */
    protected void closeAdminSession(final Session adminSession) {
        if (adminSession != null && adminSession.isLive()) {
            adminSession.logout();
        }
    }

    /**
     * Gets session from resource {@link Session}.
     * @param resource the resource for which to retrieve the session
     * @return The <code>Session</code> or <code>null</code> if the session couldn't be created.
     */
    protected Session getSessionFromResource(final Resource resource) {
        return resource.getResourceResolver().adaptTo(Session.class);
    }

    /**
     * Creates an administrative {@link Session}. The user backing the administrative session has only the access
     * typically needed to perform operations on Community related resources.
     * @return The <code>Session</code> or <code>null</code> if the session couldn't be created.
     */
    protected Session createAdminSession() {
        try {
            /*
             * Need to do our *own* get of the service, Felix DS would associate the repo with the bundle implementing
             * the concrete service. In that case each implementing bundle would have to have its own configuration
             * entry for UGC_WRITER. Using the ServiceTracker they get associated with *this* bundle and we only need
             * one configuration entry.
             */
            SlingRepository repository = BundleServices.getService(SlingRepository.class);
            ServiceUserWrapper serviceUserWrapper = BundleServices.getService(ServiceUserWrapper.class);
            return serviceUserWrapper.loginService(repository, UGC_WRITER);
        } catch (final RepositoryException e) {
            log.error("error creating session: ", e);
        }
        return null;
    }

}
