/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.scf.utilities.api;

import javax.annotation.CheckForNull;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.granite.security.user.UserProperties;
import com.day.cq.wcm.api.Page;

public interface SCFUtilities {

    enum AVATAR_SIZE {
        /**
         * Avartar's size for 32 and for 48.
         */
        THIRTY_TWO(32), FORTY_EIGHT(48), EIGHTY(80), THIRTY_FOUR(34);
        /**
         * Avartar's size.
         */
        private final int size;

        /**
         * Set avartar's size for 32 and for 48.
         * @param s The size for avatar
         */
        AVATAR_SIZE(final int s) {
            size = s;
        }

        @Override
        public String toString() {
            return String.valueOf(this.size);
        }
    }

    /**
     * Finds the page which contains the given resource.
     * @param resource the resource for which the page is to be found
     * @return the page that contains the resource
     */
    @CheckForNull
    Page getContainingPage(Resource resource);

    /**
     * Gets the social profile url for a user based on the page being passed in. The form used to show the profile
     * will be the read from "cq:socialProfilePage" in the content hierarchy "above" the page requested.
     * @param username user to find the profile for.
     * @param resolver the resolver to use, which must have read access to the profile other
     * @param page the page to use as the basis for the search for "cq:socialProfilePage" property.
     * @return a url to the profile or null if the username was not found.
     */
    String getSocialProfileURL(final String username, final ResourceResolver resolver, final Page page);

    /**
     * Returns the user properties denoted by the given <code>userId</code>. The user props are looked for using the
     * provided resource resolver, so as to ensure that the user properties are only accessible to users having the
     * necessary access rights on the requested user properties.
     * @param resolver The {@link ResourceResolver}.
     * @param userId The user id for which to retrieve the user properties.
     * @return The {@link UserProperties} or <code>null</code> if not found.
     */
    UserProperties getUserProperties(final ResourceResolver resolver, final String userId);

    /**
     * Returns the userProperties avatar URL or {@link CollabUtil#DEFAULT_AVATAR} if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties);

    /**
     * Returns the userProperties avatar URL or {@link CollabUtil#DEFAULT_AVATAR} if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @param absoluteDefaultAvatar The absolute default avatar
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties, final String absoluteDefaultAvatar);

    /**
     * Returns the userProperties avatar URL or absoluteDefaultAvatar if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @param absoluteDefaultAvatar The absolute default avatar
     * @param size The avatar size (for example, 32)
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties, final String absoluteDefaultAvatar, final AVATAR_SIZE size);

    /**
     * Returns the userProperties avatar URL or {@link CollabUtil#DEFAULT_AVATAR} if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @param size The avatar size (for example, 32)
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties, final int size);
}
