/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.scf.utilities.internal;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.wcm.api.Page;

public interface InternalSCFUtilities {
    final String DEFAULT_AVATAR = "/etc/designs/default/images/social/avatar.png";

    /**
     * Returns the given <code>resource</code>'s path without its potential <i>/jcr:content/...</i> suffix, thus
     * representing a page path.
     * @param resource The resource to check.
     * @return A <code>String</code> representing the page path.
     */
    @CheckForNull
    String getPagePath(@Nullable final Resource resource);

    /**
     * Returns the given <code>resource</code>'s path without its potential <i>/jcr:content/...</i> suffix, thus
     * representing a page path.
     * @param path The path to check.
     * @return A <code>String</code> representing the page path.
     */
    @CheckForNull
    String getPagePath(@Nullable final String path);

    /**
     * @param path path to the page
     * @param resolver resolver to us
     * @return the {@link Page} object for the given path if a page exists, null otherwise.
     */
    @CheckForNull
    Page getPage(String path, ResourceResolver resolver);

    /**
     * Returns the resource type from the design applied to the resource.
     * @param resource the resource to check the design property for
     * @param styleProperty the name of the design property to check
     * @param defaultValue a default string value
     * @return the resource
     */
    @CheckForNull
    String getResourceTypeFromDesign(final Resource resource, final String styleProperty, final String defaultValue);

    /**
     * Returns the resource type of a Component when it is included dynamically via cq:include. This will check the
     * component node, then the design to determine if one is available, if it cannot retrieve another resource type
     * it will return the defaultResourceType.
     * @param component the component to determine the type for
     * @param defaultResourceType the fall back if no suitable matchers are found
     * @param designPropertyName the name of the design property to try and use
     * @return a valid resource type to use when dealing with dynamically included components
     */
    @CheckForNull
    String getResourceTypeForIncludedResource(final Resource component, final String defaultResourceType,
        final String designPropertyName);
}
