/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scoring.api;

import com.adobe.cq.social.srp.utilities.internal.InternalSocialResourceUtilities;

/**
 * ScoringConstants contains the constants used by Scoring bundle.
 */
public final class ScoringConstants {
    /** score engine type. */
    public static final String SCORING_TYPE_PROP = "scoringType";
    /** scoring rule property. */
    public static final String SCORING_RULES_PROP = "scoringRules";
    /** The topic for the OSGi event which is sent when a score is added for a user. */
    public static final String TOPIC_SOCIAL_SCORING_ADDED = "com/adobe/cq/social/scoring/ADDED";
    /** set to true if this rule applies the ugc owner and not the actor. */
    public static final String FOR_OWNER_PROP = "forOwner";
    /** sub rules that defines a scoring rule. */
    public static final String SUB_RULES_PROP = "subRules";
    /** sub rule event topics. */
    public static final String TOPICS_PROP = "topics";

    /* properties that are sent with the TOPIC_SOCIAL_SCORING_ADDED event. */
    /** userid. */
    // Removes dependency on UGCBase
    public static final String USERID_PROP = "userIdentifier";
    /** full path of the score resource. */
    public static final String SCORE_NAME_PROP = "scoreName_s";
    /** the new score for the user for this rule. */
    public static final String SCORE_VALUE_PROP = "scoreValue_tl";
    /** the component path where the score rule is located. */
    public static final String COMPONENT_PATH_PROP = InternalSocialResourceUtilities.PN_CS_ROOT;

    /**
     * Overriding the default constructor for the Constants class.
     */
    private ScoringConstants() {
    }
}
