/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scoring.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.sling.api.resource.Resource;

/**
 * Scoring engine interface.
 */
public interface ScoringEngine {
    /**
     * Calcuate score based on engine's algorithm.
     * @param scoreRule scoringRule resource
     * @param subRule The scoring sub rule resource
     * @param verb The action verb from a SocialEvent
     * @param topic The topic from a SocialEvent
     * @param userId The user the score should apply to
     * @param ugcResource The UGC resource used for the scoring calculation
     * @param componentResource The component where the rule is located
     */
    void applyRule(@Nonnull Resource scoreRule, @Nonnull Resource subRule, @Nonnull String verb,
        @Nullable final String topic, @Nonnull String userId, @Nonnull Resource ugcResource,
        @Nonnull Resource componentResource);

    /**
     * Get this scoring engine type.
     * @return the engine type
     */
    @Nonnull
    String getScoringType();

    /**
     * Process UGC for scoring even though no rule was defined.
     * @param ruleAction The event's action verb
     * @param ugcResource The UGC resource used for the scoring calculation
     */
    void unscoredData(@Nonnull String ruleAction, @Nonnull Resource ugcResource);
}
