/**************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.scoring.api;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Scoring service exposes operations like getPoints needed by components.
 */
public interface ScoringService {

    /**
     * Retrieves score specified by scoreName for user.
     * @param resourceResolver - resolver used to read the resources
     * @param userId - the user's userid
     * @param componentResource - the resource where the scoring rule was applied
     * @param scoreRuleResource - resource of score to be retrieved
     * @return score of the user
     * @throws RepositoryException thrown if unable to retrieve the score
     */
    long getScore(@Nonnull ResourceResolver resourceResolver, @Nonnull String userId,
        @Nonnull Resource componentResource, @Nonnull Resource scoreRuleResource) throws RepositoryException;

    /**
     * Saves score specified by scoreName for user.
     * @param resourceResolver - resolver of the user whose score needs to be retrieved
     * @param userId - the user's userid
     * @param componentResource - the resource where the scoring rule was applied
     * @param scoreRuleResource - name of score to be retrieved
     * @param scoreValue - score value, in the form of an increment, to save
     * @throws RepositoryException, PersistenceException thrown if unable to save the score
     */
    void saveScore(@Nonnull ResourceResolver resourceResolver, @Nonnull String userId,
        @Nonnull Resource componentResource, @Nonnull Resource scoreRuleResource, long scoreValue)
        throws RepositoryException, PersistenceException;

    /**
     * Returns the path of a score resource.
     * @param resourceResolver - resolver of the user whose score needs to be retrieved
     * @param userId - the user's userid
     * @param componentResource - the resource where the scoring rule was applied
     * @param scoreRuleResource - name of score to be retrieved
     * @return the path of score resource
     * @throws RepositoryException if unable to calculate the score path
     */
    @CheckForNull
    String getScoreResourcePath(@Nonnull final ResourceResolver resourceResolver, @Nonnull final String userId,
        @Nonnull final Resource componentResource, @Nonnull final Resource scoreRuleResource)
        throws RepositoryException;
}
