/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.serviceusers.internal;

import java.util.Map;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;

/**
 * A wrapper for service user functionality in Sling. By passing all calls through this wrapper clients can mitigate
 * risk associated with the need to backport code to environments which don't support service users or the service
 * users of interest. In those environments this service can be replaced with a version which maps some or all service
 * users to the admin user.
 * @author rryan
 */
public interface ServiceUserWrapper {

    /**
     * Returns a new session for the given service user alias.
     * @param repo The Sling repository.
     * @param alias The alias, may be null if only one service user is configured for the bundle providing the
     *            repository instance.
     * @return The session authenticated as the service user.
     * @throws LoginException If the service user cannot be logged in.
     * @throws RepositoryException If other repository errors are encountered while creating the session.
     */
    Session loginService(SlingRepository repo, String alias) throws LoginException, RepositoryException;

    /*
     * Returns a new session impersonating with the given credentials via the given service user alias. NOTE: on 6.1
     * AEM the underlying API does not exist in the SlingRepository class. On 6.1 AEM the returned session will
     * actually belong to the service user specified.
     * @param repo The Sling repository.
     * @param alias The alias, may be null if only one service user is configured for the bundle providing the
     * repository instance.
     * @param cred The credentials controlling impersonation.
     * @return The session authenticated as the service user.
     * @throws LoginException If the service user cannot be logged in.
     * @throws RepositoryException If other repository errors are encountered while creating the session.
     */
    Session impersonateFromService(final SlingRepository repo, final String alias, final Credentials cred)
        throws LoginException, RepositoryException;

    /**
     * Returns a new ResourceResolver for the given service user alias.
     * @param factory The ResourceResolverFactory.
     * @param authInfo authInfo map containing the ResourceResolverFactory.SUBSERVICE value naming the alias to use.
     * @return The ResourceResolver authenticated as the service user.
     * @throws org.apache.sling.api.resource.LoginException If the service user cannot be logged in.
     */
    ResourceResolver getServiceResourceResolver(final ResourceResolverFactory factory,
        final Map<String, Object> authInfo) throws org.apache.sling.api.resource.LoginException;
}
