/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp;

import java.io.IOException;
import java.util.Map;

public class APICommand {

    public int methodType;

    public String providerId;

    public Map<String, Object> body;

    public Map<String, Object> map;

    final public static int CREATE = 1;
    final public static int UPDATE = 2;
    final public static int DELETE = 3;
    final public static int INCREMENT = 4;

    public APICommand(final int methodType, final String providerId, final Map<String, Object> body)
        throws IOException {

        this.providerId = providerId;
        switch (methodType) {
            case CREATE:
            case UPDATE:
            case INCREMENT:
                this.body = body;
            case DELETE:
                break;
            default:
                throw new IOException("unknown method type");
        }

        this.methodType = methodType;

    }

    public APICommand(final int methodType, final String providerId, final Map<String, Object> body,
        final Map<String, Object> map) throws IOException {
        this.map = map;
        this.providerId = providerId;
        switch (methodType) {
            case CREATE:
            case UPDATE:
            case INCREMENT:
                this.body = body;
            case DELETE:
                break;
            default:
                throw new IOException("unknown method type");
        }

        this.methodType = methodType;
    }
}
