/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.srp;

import org.apache.sling.api.resource.PersistenceException;
import java.util.List;

public class APIException extends PersistenceException {
    private List<Integer> codes;
    private List<String> keys;
    private List<Integer> methodTypes;
    private String message;

    public APIException(final String message, final List<Integer> codes, final List<String> keys,
        final List<Integer> methodTypes) {
        this.message = message;
        this.codes = codes;
        this.keys = keys;
        this.methodTypes = methodTypes;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public List<Integer> getMethodTypes() {
        return this.methodTypes;
    }

    public List<String> getKeys() {
        return this.keys;
    }
}
