/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp;

import java.util.Date;

public class FacetRangeField {
    /**
     * Defines for date range. For example, to set gap at one month, the gap argument would be +1MONTH WEEK is not
     * supported (Solr does not support it due to year end issues) NOW is the current time.
     */
    public static final String NOW = "NOW";
    public static final String YEAR = "YEAR";
    public static final String MONTH = "MONTH";
    public static final String DAY = "DAY";
    public static final String HOUR = "HOUR";
    public static final String MINUTE = "MINUTE";

    private final String fieldName;

    private final long startValue;
    private final long endValue;
    private final long gapValue;

    private final Date startDate;
    private final Date endDate;
    private final String gapDateRange;

    private boolean isDateRange;

    public FacetRangeField(final String fieldName, final long startValue, final long endValue, final long gapValue) {
        this.fieldName = fieldName;
        this.startValue = startValue;
        this.endValue = endValue;
        this.gapValue = gapValue;
        this.isDateRange = false;
        // Initialize to null, not used if numeric.
        this.startDate = null;
        this.endDate = null;
        this.gapDateRange = null;
    }

    public FacetRangeField(final String fieldName, final Date startDate, final Date endDate, final String gapValue) {
        this.fieldName = fieldName;
        this.startDate = startDate;
        this.endDate = endDate;
        this.gapDateRange = gapValue;
        this.isDateRange = true;
        // Initialize to max, not used if date
        this.startValue = Integer.MAX_VALUE;
        this.endValue = Integer.MAX_VALUE;
        this.gapValue = Integer.MAX_VALUE;
    }

    public boolean getIsDateRange() {
        return this.isDateRange;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public String getDateGap() {
        return gapDateRange;
    }

    public long getStartValue() {
        return startValue;
    }

    public long getEndValue() {
        return endValue;
    }

    public long getGapValue() {
        return gapValue;
    }

}
