/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp;

import java.util.Collections;
import java.util.Map;

/**
 * Facet results.
 */
public class FacetSearchResult {

    /**
     * The facet count results.
     */
    private Map<String, Map<String, Integer>> facetCountResult;

    /**
     * The facet range results.
     */
    private Map<String, Map<String, Integer>> facetRangeResult;

    public FacetSearchResult() {
        this.facetCountResult = Collections.emptyMap();
        this.facetRangeResult = Collections.emptyMap();
    }

    public FacetSearchResult(final Map<String, Map<String, Integer>> countResults,
        final Map<String, Map<String, Integer>> rangeResults) {
        this.facetCountResult = countResults;
        this.facetRangeResult = rangeResults;
    }

    /**
     * Set the facet count results.
     * @param countResult the count results.
     */
    public void setCountResult(final Map<String, Map<String, Integer>> countResult) {
        this.facetCountResult = countResult;
    }

    /**
     * Get facet count result.
     * @return facet counts.
     */
    public Map<String, Map<String, Integer>> getCountResult() {
        return this.facetCountResult;
    }

    /**
     * Set the facet range results.
     * @param rangeResult the range results.
     */
    public void setRangeResult(final Map<String, Map<String, Integer>> rangeResult) {
        this.facetRangeResult = rangeResult;
    }

    /**
     * Get facet range result.
     * @return facet range counts.
     */
    public Map<String, Map<String, Integer>> getRangeResult() {
        return this.facetRangeResult;
    }
}
