/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp;

public class SearchSortField {

    /**
     * The direction.
     */
    private final boolean isAscending;

    /**
     * The property name.
     */
    private final String propertyName;

    /**
     * Construct a sort field.
     * @param propertyName the name of the property.
     * @param isAscending true if ascending
     */
    public SearchSortField(final String propertyName, final boolean isAscending) {
        this.isAscending = isAscending;
        this.propertyName = propertyName;
    }

    /**
     * Return the property name.
     * @return the property name.
     */
    public String getPropertyName() {
        return this.propertyName;
    }

    /**
     * Return true if ascending.
     * @return true if ascending.
     */
    public boolean isAscending() {
        return isAscending;
    }

}
