/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp;

import java.util.ArrayList;

/**
 * A list implementation of SearchResults. Similar to SolrDocumentList
 * @param <T> type of objects stored
 */
public class SocialResourceSearchResult<T> extends ArrayList<T> {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * The total number of results.
     */
    private long numFound;

    /**
     * Constructor.
     */
    public SocialResourceSearchResult() {
        super();
        numFound = 0;
    }

    /**
     * The number of search results, if 'requiresTotal' is true or if no limit is provided. Otherwise, this will
     * return a value greater than limit iff there is more content available.
     * @return total number of search hits
     * @see SocialResourceProvider#find(org.apache.sling.api.resource.ResourceResolver, String, String,
     *      java.util.List, int, int, boolean)
     */
    public long getNumFound() {
        return numFound;
    }

    /**
     * set the total number of search hits.
     * @param numFound total number of search hits
     */
    public void setNumFound(final long numFound) {
        this.numFound = numFound;
    }
}
