/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp.config;

import javax.annotation.Nonnull;

/**
 * MSRP specific configuration information details.
 */
public interface MSRPConfiguration extends SocialResourceConfiguration {

    final String PN_MONGO_URI = "mongouri";
    final String PN_MONGO_ATTACHMENTCOLLECTION = "attachments";
    final String PN_MONGO_UGCCOLLECTION = "collection";
    final String PN_MONGO_DB = "ugc";

    final String PN_SOLRCOLLECTION = "solr.collection";
    final String PN_SOLRURL = "solr.url";

    final String PN_ZKHOST = "zkhost";

    /**
     * Get mongoDB URI for MSRP.
     * @return host URI
     */
    String getMongoURI();

    /**
     * Get mongoDB database name for MSRP.
     * @return database name
     */
    String getDatabaseName();

    /**
     * Get mongoDB collection name to use for the UGC storage.
     * @return collection name
     */
    String getUGCCollectionName();

    /**
     * Get mongoDB collection name to use for the attachment storage.
     * @return collection name
     */
    String getAttachmentCollectionName();

    /**
     * Get Zookeeper URI.
     * @return zookeeper uri
     */
    String getZooKeeperURI();

    /**
     * Get Solr URL.
     * @return solr url
     */
    String getSolrURL();

    /**
     * Get Solr collection name.
     * @return solr url
     */
    String getSolrCollectionName();

    /**
     * Get Tenant ID or default if not in a tenant.
     * @return tenantid
     */
    @Nonnull
    String getTenantId();

}
