/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public interface SRPConfigurationFactory {

    /**
     * Creates a configuration based on a resource.
     * @param resource configuration resource to use as the basis
     * @return the configuration specific to the SRP being used
     */
    SocialResourceConfiguration createConfiguration(@Nullable final Resource resource) throws SRPConfigurationError;

    /**
     * Creates a configuration based on a resource.
     * @param vm configuration valuemap to use as the basis
     * @return the configuration specific to the SRP being used
     */
    SocialResourceConfiguration createConfiguration(@Nonnull final ValueMap vm) throws SRPConfigurationError;

}
