/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.srp.config;

import org.apache.commons.lang3.StringUtils;

/**
 * Social Resource Provider configuration.
 */
public interface SocialResourceConfiguration {

    final String PN_ASIPATH = "asipath";
    final String PN_TENANT_ID = "tenantid";

    /**
     * The available SRP types.
     */
    public static enum SRPTYPE {
        MSRP("msrp"), ASRP("asrp"), JSRP("jsrp");
        private String code;

        private SRPTYPE(final String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static SRPTYPE getEnum(final String code) {
            if (StringUtils.equalsIgnoreCase(code, "MSRP")) {
                return MSRP;
            }
            if (StringUtils.equalsIgnoreCase(code, "ASRP")) {
                return ASRP;
            }
            return JSRP;

        }
    }

    /**
     * Get asiPath.
     * @return asiPath
     */
    String getAsiPath();

}
