/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp.internal;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.adobe.cq.social.srp.ProviderMetaData;

public abstract class AbstractProviderMetaData extends AbstractMap<String, Object> implements ProviderMetaData {

    private final Map<String, Object> data;
    private boolean bSupportsMultiLingualSearch;

    public AbstractProviderMetaData(boolean bSupportsMultiLingualSearch) {
        super();
        this.bSupportsMultiLingualSearch = bSupportsMultiLingualSearch;
        this.data = new HashMap<String, Object>();
    }

    @Override
    public Set<java.util.Map.Entry<String, Object>> entrySet() {
        return data.entrySet();
    }

    @Override
    public boolean getRequiresComponentSync() {
        return false;
    }

    @Override
    public boolean getRequiresSentimentAnalysis() {
        return true;
    }

    @Override
    public boolean getSupportsMultiLingualSearch() {
        return bSupportsMultiLingualSearch;
    }
}
