/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.srp.internal;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.srp.SocialResourceProvider;

/**
 * This interface is useful for providers that do caching. In particular, they may need to adjust their cache when a
 * resource is modified. For creates and deletes, such updates are easy because create and delete is done through the
 * provider directly. However, modifications happen on the resource.
 */
public interface CachingResourceProvider extends SocialResourceProvider {

    /** The atomic increment key. */
    public static final String INC = "$inc";

    /**
     * Called when resource (which is owned by this provider) is modified.
     * @param resource the modified resource
     */
    void update(Resource resource);

}
