/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.srp.utilities.internal;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;

public interface InternalSocialResourceUtilities {
    /**
     * Where config definitions are stored. TODO: Temporary This will change once the config location settles down.
     */

    String SRP_CONFIGURATION_ROOT = "/etc/socialconfig/srpc/";
    String SRP_DEFAULT_CONFIG_PATH = SRP_CONFIGURATION_ROOT + "defaultconfiguration";
    String PATH_UGC = "/content/usergenerated";

    /**
     * The SRP prefix.
     */
    String ASI_UGC_PREFIX = PATH_UGC + "/asi";

    /**
     * The key used to describe a parent resource.
     */
    String PN_PARENTID = "social:parentid";
    String PN_BASETYPE = "social:baseType";
    String PN_CS_ROOT = "social:rootCommentSystem";
    String PN_ATTACHMENT_LIST = "social:attachments";

    // Maybe move to mapper.
    String PN_DS_KEY = "social:key";

    // Used in Mapper and ASRP
    String PN_IS_REPLY = "social:isReply";

    // Only used in ASRP?
    String PN_ENTITY = "social:entity";

    /**
     * The date field name.
     */
    String PN_DATE = "added";

    /**
     * The resources type for comments.
     */
    String PN_COMMENT_RESOURCETYPE = "commentresourcetype";

    /**
     * Map a UGC path, avoiding multiple round trips.
     * @param ugcPath the path to map
     * @param resolver the resolver to use to try and map the path
     * @return the mapped path
     */
    @CheckForNull
    String mapUGCPath(final String ugcPath, final ResourceResolver resolver);

    /**
     * Gets the default configuration set for the system.
     * @return a configuration for the social data store or null if one does not exist
     */
    @CheckForNull
    SocialResourceConfiguration getDefaultStorageConfig();

    /**
     * Creates a valid and unique JCR Node name given the message. This will include 4 characters of entropy added to
     * prevent similarly named collisions.
     * @param message a starting to point for the name, will be stripped of invalid node name characters.
     * @return a String with a unique name
     */
    @Nonnull
    String createUniqueNameHint(final String message);

    /**
     * Creates a valid and unique JCR Node name given the message. This will the requested amount of of entropy added
     * to prevent similarly named collisions.
     * @param message a starting to point for the name, will be stripped of invalid node name characters.
     * @param numRandomChars the number of characters to add as random noise in the name
     * @return a String with a unique name
     */
    @Nonnull
    String createUniqueNameHint(final String message, final int numRandomChars);

    /**
     * Generates a (secure) random string with the given length.
     * @param length length of random string.
     * @return a random string.
     */
    @Nonnull
    String generateRandomString(final int length);

    /**
     * Prepare user generated content for the specified path. The path can be the page path or the ugc collection
     * root.
     * @param resolver The {@link ResourceResolver} to use for persisting values.
     * @param path The page path
     * @return the user generated content page path.
     * @throws SocialException if error occurs in Social Collaboration
     */
    String prepareUserGeneratedContent(final ResourceResolver resolver, final String path) throws SocialException;

    /**
     * Prepare the needed page paths in /content/usergenerated.
     * @param resolver Depending on the value of writeWithResolver, a resolver that can be used to read and/or write
     *            the ugc page path
     * @param path The page path
     * @param typeHint the resource type for the last part of the page path or null.
     * @param writeWithResolver If true, resolver can be used to both read and write the UGC page path. If false,
     *            resolver can only be used to read the UGC page path. A service user will be used to create it if
     *            needed.
     * @return the user generated content page path.
     * @throws SocialException on failure
     */
    String prepareUserGeneratedContentWithLeafTypeHint(final ResourceResolver resolver, final String path,
        final String typeHint, final boolean writeWithResolver) throws SocialException;
}
