/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.subscriptions.api;

public interface Subscription {
    String PROP_TYPE = "type_s";
    String PROP_REL_TYPE = "rel_type_s";
    String PROP_STARTID = "startid_s";
    String PROP_ENDID = "endid_s";
    String SUBSCRIPTION_RESOURCE_TYPE = "social/subscriptions/components/hbs/subscription";
    String SUBSCRIPTION_RELATION_TYPE = "notification";
    String EMAIL_SUBSCRIPTION_RELATION_TYPE = "emailsubscription";

    /**
     * Get the id the user wants to subscribe to. The id can be a resource path, or a user id.
     * @return the subscribed id
     */
    String getSubscribedId();

    /**
     * Get the owner of the subscription
     * @return
     */
    String getOwner();

    /**
     * Get the path of this subscription
     */
    String getPath();

    /**
     * Get subscription type, ie., following, notification
     * @return
     */
    String getSubscriptionType(); // Following or Notification

    /**
     * Get the subscription category, i.e, RESOURCE, USER, etc..
     */
    String getCategory();
}
