/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.subscriptions.api;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.apache.sling.api.resource.ResourceResolver;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.cq.social.ugc.api.UgcFilter;

public interface SubscriptionManager {
    /**
     * Gets subscription objects for a target and owner combination.
     * @param resolver the resolver to use to read the subscription
     * @param subscribeTo the target of the subscription
     * @param owner the owner of this particular subscription
     * @return a subscription object or null if not found
     */
    @CheckForNull
    List<Subscription> getSubscriptions(final ResourceResolver resolver, final String subscribeTo,
        final String owner, final String... types);

    /**
     * Gets subscriptions for a particular owning resource.
     * @param resolver the resolver to use to read the subscriptions
     * @param ownerId a path to the owner of the subscription
     * @return a list of subscriptions
     */
    @Nonnull
    List<Subscription> getSubscriptions(final ResourceResolver resolver, final String ownerId,
        final Direction direction);

    List<Subscription> getSubscriptions(final ResourceResolver resolver, final String subTypeId, final int startIndex, final int size);

    List<Subscription> getSubscriptions(final ResourceResolver resolver, final String subTypeId,
        final UgcFilter filter, final int startIndex, final int size);
}
