/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.subscriptions.api;

import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.subscriptions.client.api.UserSubscriptionPreferences;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.activitystreams.Activity;

public interface SubscriptionPreferencesEvaluator extends PreferencesEvaluator {

    /**
     * Evaluates whether the specified activity matches with the specified subscription
     * @param socialUtils
     * @param resolver
     * @param channelId
     * @param categoryId
     * @param userPreferences
     * @return
     */
    boolean evaluate(SocialUtils socialUtils, ResourceResolver resolver, final Subscription subscription,
        final Activity activity, String channelId, final String categoryId,
        UserSubscriptionPreferences userPreferences);

    /**
     * Provide the <code>UgcFilter</code> that is used to fetch the subscriptions for the specified category and
     * activity.
     * @param socialUtils
     * @param resolver
     * @param category
     * @param activity
     * @return
     */
    UgcFilter getFilter(final SocialUtils socialUtils, final ResourceResolver resolver, final String category,
        final Activity activity);
}
