/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.subscriptions.api;

import org.apache.commons.lang.StringUtils;

import com.adobe.cq.social.graph.Edge;
import com.adobe.cq.social.graph.client.api.Following;
import com.adobe.cq.social.subscriptions.api.Subscription;

/**
 * Subscription types that we support.
 */
public enum SubscriptionType {
    FOLLOWING("Followings", Edge.FOLLOWING_RELATIONSHIP_TYPE, Following.RESOURCE_TYPE, "Activities", null), SUBSCRIPTION(
        "Subscriptions", Subscription.SUBSCRIPTION_RELATION_TYPE, Subscription.SUBSCRIPTION_RESOURCE_TYPE,
        "Notifications", null) /*
                                * , EMAILSUBSCRIPTIONS( "EmailSubscriptions",
                                * Subscription.EMAIL_SUBSCRIPTION_RELATION_TYPE,
                                * Subscription.SUBSCRIPTION_RESOURCE_TYPE, "Email Notifications", new String[]
                                * {"social/forum/components/hbs/forum", "social/forum/components/hbs/topic",
                                * "social/forum/components/hbs/post"})
                                */;

    private final String name;
    private final String id;
    private final String resourceType;
    private final String displayName;
    private final String supportedTypes[];

    SubscriptionType(final String name, final String id, final String resourceType, final String displayName,
        final String supportedTypes[]) {
        this.name = name;
        this.id = id;
        this.resourceType = resourceType;
        this.displayName = displayName;
        this.supportedTypes = supportedTypes;
    }

    /**
     * Get the name of this SubscriptionType
     */
    public String getValue() {
        return name;
    }

    /**
     * Get the com.adobe.cq.social.graph.Relationship type
     * @return
     */
    public String getRelationshipId() {
        return id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String[] getSupportedTypes() {
        return this.supportedTypes.clone();
    }

    public boolean supportedAllTypes() {
        return (this.supportedTypes == null || this.supportedTypes.length == 0);
    }

    public static SubscriptionType getByRelationshipId(final String id) {
        if (StringUtils.isNotEmpty(id)) {
            for (SubscriptionType type : SubscriptionType.values()) {
                if (id.equals(type.getRelationshipId())) {
                    return type;
                }
            }
        }
        return null;
    }

    public static SubscriptionType getByValue(final String value) {
        if (StringUtils.isNotEmpty(value)) {
            for (SubscriptionType type : SubscriptionType.values()) {
                if (value.equals(type.getValue())) {
                    return type;
                }
            }
        }
        return null;
    }
}