/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.subscriptions.api;

import java.util.Collection;

import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.subscriptions.client.api.UserSubscriptionPreferences;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.activitystreams.Activity;

public interface SystemPreferencesEvaluator extends PreferencesEvaluator {
    /**
     * Get list of owner id fo the specified categoryId and activity
     * @param resolver
     * @param categoryId
     * @param activity
     * @return a list of user whom the notification belongs to.
     */
    Collection<String> getOwnerIds(ResourceResolver resolver, String categoryId, Activity activity);

    /**
     * Evaluates whether the specified activity matches with the specified userPreferences
     * @param socialUtils
     * @param resolver
     * @param channelId
     * @param categoryId
     * @param userPreferences
     * @return
     */
    boolean evaluate(SocialUtils socialUtils, ResourceResolver resolver, final Activity activity, String channelId,
        final String categoryId, UserSubscriptionPreferences userPreferences);
}
