/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.subscriptions.client.api;

import java.util.Map;

import com.adobe.cq.social.scf.SocialComponent;

public interface SubscriptionCollection extends SocialComponent {
    String RESOURCE_TYPE = "social/subscriptions/components/hbs/subscriptions";

    /**
     * Get the id the user wants to subscribe to. The id can be a resource path, or a user id.
     * @return the subscribed id
     */
    String getSubscribedId();

    /**
     * Get the owner of the subscription
     * @return
     */
    String getOwner();

    /**
     * Get the path of this subscription
     */
    String getPath();

    /**
     * Get the list of subscription types
     * @return
     */
    String[] getTypes();

    /**
     * Get the subscription status of this collection
     * @return
     */
    Map<String, SubscriptionStatus> getStates();

    /**
     * Check if there is a selection in this collection
     */
    boolean isSubscribed();

    /**
     * Check if there is a login session
     */
    boolean isUserLoggedIn();
}
