/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.subscriptions.client.api;

import java.util.Collection;
import java.util.Map;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.ValueMap;

import com.adobe.cq.social.scf.SocialComponent;

public interface UserSubscriptionPreferences extends SocialComponent {
    String RESOURCE_TYPE = "social/subscriptions/components/hbs/subscriptionpreferences";

    /**
     * List of channels
     * @return
     */
    public Collection<String> getChannels();

    /**
     * List of categories
     * @throws RepositoryException
     */
    public Map<String, Collection<String>> getChannelCategories() throws RepositoryException;

    /**
     * Get the category settings for all the channels. The key of the map is the channel id, the value of each item in
     * the map is a <code>Map</code>, which provides the category settings.
     * @return
     * @throws RepositoryException
     */
    public Map<String, Map<String, ValueMap>> getCategorySettings() throws RepositoryException;

}
