/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.subscriptions.endpoint;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolverFactory;

import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;

public interface SubscriptionCollectionOperations {
    String PROP_SUBSCRIBED_ID = "subscribedId";
    String PROP_STATES = "states";
    String PROP_TYPES = "types";
    String PROP_USER_ID = "userId";

    /**
     * select and unselect list of subscription base on the specified {@link SlingHttpServletRequest}
     * @param request the client request
     * @return the subscription {@link SocialComponent}
     * @throws OperationException if there is an error occurs
     */
    SocialComponent update(final SlingHttpServletRequest request) throws OperationException;
}
